package dati;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Carrello che puo' contenere dei prodotti.
 */
public class Carrello {
    
    /**
     * i prodotti contenuti nel carello
     */
    protected List prodotti;

    /**
     * crea un carrello vuoto
     */
    public Carrello() {
        prodotti = new ArrayList();
    }
    
    /**
     * aggiunge un prodotto al carrello
     * @param l il prodotto da aggiungere
     */
    public void aggiungiProdotto(Prodotto l){
        prodotti.add(l);
    }
    
    /**
     * toglie un prodotto dal carrello
     * @param l il prodotto da togliere
     */
    public void togliProdotto(Prodotto l){
        prodotti.remove(l);
    }
    
    /**
     * restituisce il prezzo totale dei prodotti nel carrello
     * @return il prezzo totale
     */
    public float getConto(){
        float conto = 0;
        for (Iterator it = prodotti.iterator(); it.hasNext();) {
            Prodotto l = (Prodotto) it.next();
            conto += l.getPrezzo();
        }
        return conto;
    }

    /**
     * restituisce una stringa descrittiva del carrello che elenca tutti i 
     * prodotti contenuti
     * @return una stringa descrittiva del carrello
     */
    @Override
    public String toString() {
        return "Carrello{" + "prodotti=" + prodotti + '}';
    }

    
    /**
     * controlla se il carrello e' uguale a un secondo carrello.
     * Due carrelli sono uguali se sono oggetti della stessa classe e se contengono
     * liste di prodotti uguali (stessi prodotti nello stesso ordine)
     * @param obj il carrello con cui confrontare questo
     * @return true se obj e' un carrello uguale a questo, false altrimenti
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Carrello other = (Carrello) obj;
        if (this.prodotti != other.prodotti && (this.prodotti == null || !this.prodotti.equals(other.prodotti))) {
            return false;
        }
        return true;
    }
    
    
    
    
}
