package dati;

/**
 * classe Libro. Le caratteristiche 
 * di un libro sono il titolo, il codice
 * isbn e il prezzo.
 */
public class Libro implements Prodotto{
    
    /**
     * il titolo del libro
     */
    protected String titolo;
    
    /**
     * il codice isbn del libro
     */
    protected String isbn;
    
    /**
     * il prezzo del libro
     */
    protected float prezzo;
    
    
    /**
     * crea un libro con titolo, codice isbn e prezzo specificati
     * @param titolo il titolo del libro
     * @param c il codice isbn del libro
     * @param p il prezzo
     */
    public Libro(String titolo, String c, float p){
        this.titolo = titolo;
        isbn = c;
        prezzo = p;
    }
    
    /**
     * calcola il prezzo del libro
     * @return il prezzo
     */
    public float getPrezzo(){
        return prezzo;
    }
    
    /**
     * ritorna la rappresentazione testuale del libro che 
     * corrisponde al suo titolo
     * @return il titolo del libro
     */
    @Override
    public String toString(){
        return titolo;
    }

    
    /**
     * Controlla se il libro e' uguale ad un secondo libro. 
     * Due libri sono uguali se hanno codice idbn uguale.
     * Oggetti di classe diversa da quella del libro corrente sono sempre 
     * diversi da questo.
     * @param obj l'oggetto con il quale confrontare il libro
     * @return true se i due libri sono uguali, false altrimenti
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Libro other = (Libro) obj;
        if ((this.isbn == null) ? (other.isbn != null) : !this.isbn.equals(other.isbn)) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
}













