package dati;

/**
 * Libro a cui e' possibile applicare uno sconto percentuale.
 */
public class LibroScontato extends Libro{
    
    /**
     * lo sconto applicato al libro.
     */
    protected int scontoPercentuale;

    /**
     * crea un libro scontato con titolo, codiceIsbn, prezzo e sconto definiti.
     * @param scontoPercentuale lo sconto applicato al prezzo del libro
     * @param titolo il titolo del libro
     * @param c il codice isbn del libro
     * @param p il prezzo intero del libro
     */
    public LibroScontato(int scontoPercentuale, String titolo, String c, float p) {
        super(titolo, c, p);
        this.scontoPercentuale = scontoPercentuale;
    }
    
    /**
     * calcola il prezzo del libro
     * @return il prezzo
     */
    public float getPrezzo(){
        return prezzo*(100-scontoPercentuale)/100;
    }
    
    
}
