package dati;

/**
 *  Film con titolo e prezzo
 */
public class Movie implements Prodotto{
    
    /**
     * il titolo del film
     */
    protected String titolo;
    
    /**
     * il prezzo del film
     */
    protected float prezzo;

    public Movie(String titolo, float prezzo) {
        this.titolo = titolo;
        this.prezzo = prezzo;
    }
    
    
    
    
    /**
     * calcola il prezzo del film
     * @return il prezzo
     */
    public float getPrezzo(){
        return prezzo;
    }


    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Movie other = (Movie) obj;
        if ((this.titolo == null) ? (other.titolo != null) : !this.titolo.equals(other.titolo)) {
            return false;
        }
        if (Float.floatToIntBits(this.prezzo) != Float.floatToIntBits(other.prezzo)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "Movie{" + "titolo=" + titolo + '}';
    }
 

    
}
