package javafx_001;

import java.io.File;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class FilesAndImages extends Application {
    public void start(Stage stage) {
		FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Carica un'immagine");
		fileChooser.getExtensionFilters().addAll(
                new FileChooser.ExtensionFilter("JPG", "*.jpg"),
                new FileChooser.ExtensionFilter("PNG", "*.png")
        );
 		String url = System.getProperty("user.home");
        File f=new File(url);        
		fileChooser.setInitialDirectory(f); // bugged on MacOsX
		File file = fileChooser.showOpenDialog(stage);
        if (file == null) {
            System.out.println("No file chosen");
            System.exit(1);
        }
        
        Image image = new Image("file://" + 			  
					file.getAbsolutePath(), 500, 500, true, true);
        ImageView iw = new ImageView(image);
        Group root = new Group(iw);
        Scene scene = new Scene(root, 500,500);
        stage.setTitle(file.getName());
        stage.setScene(scene);
        stage.sizeToScene();
        stage.show();
    }

    public static void main(String[] args) {
        Application.launch(args);
    }
}
