/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ronchet.demo1;

import it.unitn.disi.ronchet.demo1.Quadrato;
import java.awt.Toolkit;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.TilePane;

public class MyTilePane
extends TilePane {
    MyTilePane(Quadrato q) {
        final Node empty = q.empty;
        this.setPrefTileWidth(100.0);
        this.setPrefTileHeight(100.0);
        this.setPrefColumns(3);
        this.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                KeyCode keyCode = keyEvent.getCode();
                if (!keyCode.isDigitKey()) {
                    return;
                }
                int i = Integer.parseInt(keyCode.getName());
                for (Node k : MyTilePane.this.getChildren()) {
                    if (!(k instanceof Button) || !((Button)k).getId().equals(keyCode.getName())) continue;
                    k.fireEvent((Event)new ActionEvent());
                    break;
                }
            }
        });
        this.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                EventTarget target = actionEvent.getTarget();
                if (target instanceof Button) {
                    MyTilePane.this.swapIfPossible((Node)((Button)target), empty);
                }
            }
        });
    }

    void swapIfPossible(Node a, Node b) {
        int emptyIndex;
        ObservableList childrenList = this.getChildren();
        int targetIndex = childrenList.indexOf(a);
        int diff = Math.abs(targetIndex - (emptyIndex = childrenList.indexOf(b)));
        if (diff == 3 | diff == 1) {
            childrenList.remove(b);
            childrenList.remove(a);
            if (emptyIndex < targetIndex) {
                childrenList.add(emptyIndex, a);
                childrenList.add(targetIndex, b);
            } else {
                childrenList.add(targetIndex, b);
                childrenList.add(emptyIndex, a);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

