package it.unitn.disi.ronchet.demo1;

import java.awt.Toolkit;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.TilePane;

public class MyTilePane extends TilePane {

    MyTilePane(Quadrato q) {
        final Node empty = q.empty;
        setPrefTileWidth(100);
        setPrefTileHeight(100);
        setPrefColumns(3);
        addEventHandler(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>() {
            public void handle(KeyEvent keyEvent) {
                KeyCode keyCode = keyEvent.getCode();
                if (!(keyCode.isDigitKey())) {
                    return;
                }
                int i = Integer.parseInt(keyCode.getName());
                for (Node k : getChildren()) {
                    if (k instanceof Button) {
                        if (((Button) k).getId().equals(keyCode.getName())) {
                            k.fireEvent(new ActionEvent());
                            break;
                        }
                    }
                }
            }
        });
        addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>() {
            public void handle(ActionEvent actionEvent) {
                Object target = actionEvent.getTarget();
                if (target instanceof Button) {
                    swapIfPossible((Button) target, empty);
                }
            }
        });
    }
    /**
     * Verifica se due nodi sono adiacenti, e se sì scambiali di posto
     * @param a primo nodo da scambiare
     * @param b secondo nodo da scambiare 
     */
    void swapIfPossible(Node a, Node b) {
        List childrenList = getChildren();
        int targetIndex = childrenList.indexOf(a);
        int emptyIndex = childrenList.indexOf(b);
        int diff = Math.abs(targetIndex - emptyIndex);
        if (diff == 3 | diff == 1) {
            childrenList.remove(b);
            childrenList.remove(a);
            // ATTENTIONPOINT
            if (emptyIndex < targetIndex) {
                childrenList.add(emptyIndex, a);
                childrenList.add(targetIndex, b);
            } else {
                childrenList.add(targetIndex, b);
                childrenList.add(emptyIndex, a);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }

    }

}