package negozioonline;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 *
 * @author valeria viannei - valeria.viannei@alumni.unitn.it
 * @version 0.1.170403
 */
public class Carrello {

    private final List<Libro> libri;

    public Carrello() {
        libri = new ArrayList<>();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.libri);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final Carrello other = (Carrello) obj;
        return Objects.equals(this.libri, other.libri);
    }

    @Override
    public String toString() {
        String str = "Carrello: \n";
        for (Libro libro : libri) {
            str += libro.toString() + "\n";
        }
        return str;
    }

    public void aggiungi(Libro libro) {
        libri.add(libro);
    }
    
    public boolean togli(Libro libro) {
        return libri.remove(libro);
    }
    
    public Float getConto() {
        float conto = 0.0f;
        for(Libro libro : libri) {
            conto += libro.getPrezzo();
        }
        
        return conto;
    }
}
