package negozioonline;

import java.util.Objects;

/**
 *
 * @author valeria viannei - valeria.viannei@alumni.unitn.it
 * @version 0.1.170403
 */
public class Libro {

    protected String titolo;
    protected String isbn;
    protected Float prezzo;

    public Libro() {
        this(null, null, Float.NaN); // possibili valori di default
    }

    public Libro(String titolo, String isbn, Float prezzo) {
        this.titolo = titolo;
        this.isbn = isbn;
        this.prezzo = prezzo;
    }

    public Float getPrezzo() {
        return prezzo;
    }

    /**
     * Rif. slide Uguaglianza2017.pdf pg 38 - equals e hashCode 
     * Programmers should take note that any class that
     * overrides the Object.equals method must also override the Object.hashCode
     * method in order to satisfy the general contract for the Object.hashCode
     * method. In particular, c1.equals(c2) implies that
     * c1.hashCode()==c2.hashCode() (the vice versa need not be true)
     *
     * @return
     */
    @Override
    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.isbn);
        return hash;
    }

    /**
     * Confronta questo {@code Libro} con un altro {@code Libro}. Due libri sono
     * considerati uguali se e solo se le rispettive stringhe isbn sono uguali,
     * ignorando il maiuscolo/minuscolo dei caratteri.
     *
     * @param obj libro da comparare
     * @return {@code true} ise l'argomento non è {@code null} e rappresenta una
     * stringa isbn equivalente senza tener conto del maiuscolo/minuscolo ;
     * {@code false} altrimenti.
     */
    @Override
    public boolean equals(Object obj) {
        // istanza della classe e istanza dell'oggetto passato come parametro coincidono?
        if (this == obj) {
            return true;
        }

        // l'oggetto passato come parametro è istanziato?
        if (obj == null) {
            return false;
        }

        // controllo che la stringa isbn sia valorizzata per poter chiamare il metodo equalsIgnoreCase
        if (this.isbn == null) {
            return false;
        }

        if (obj instanceof Libro) {
            final Libro other = (Libro) obj;
            return this.isbn.equalsIgnoreCase(other.isbn); // this.isbn è sicuramente diverso da NULL!!
        }

        return false;
    }

    /**
     * Questa implementazione è un'alternativa al metodo proposto sopra. Come
     * ovvio, essendo la firma diversa non viene fatto l'override.
     *
     * @param obj
     * @return
     */
    public boolean equalsOption2(Object obj) {
        // istanza della classe e istanza dell'oggetto passato come parametro coincidono?
        if (this == obj) {
            return true;
        }

        // l'oggetto passato come parametro è istanziato?
        if (obj == null) {
            return false;
        }

        if (obj instanceof Libro) {
            final Libro other = (Libro) obj;

            /**
             * L'uso del metodo Objects.equals permette di confrontare due
             * oggetti senza controllare "this.isbn == null".
             *
             * Come indicato dalle API: Objects class consists of {@code static}
             * utility methods for operating on objects. These utilities include
             * {@code null}-safe or {@code null}-tolerant methods for computing
             * the hash code of an object, returning a string for an object, and
             * comparing two objects. (from Java 7)
             *
             * Nel nostro caso,
             */
            return Objects.equals(this.isbn, other.isbn);
        }

        return false;

    }

    @Override
    public String toString() {
        return "Libro{" + "titolo=" + titolo + '}';
    }
}
