package negozioonline;

/**
 *
 * @author valeria viannei - valeria.viannei@alumni.unitn.it
 * @version 0.1.170403
 */
public class LibroScontato extends Libro {

    private Integer scontoPercentuale;

    public LibroScontato() {
        this(0); // nessuno sconto applicato
    }

    public LibroScontato(Integer scontoPercentuale) {
        this.scontoPercentuale = scontoPercentuale;
    }

    public LibroScontato(Integer scontoPercentuale, String titolo, String isbn, Float prezzo) {
        super(titolo, isbn, prezzo);
        this.scontoPercentuale = scontoPercentuale;
    }

    @Override
    public Float getPrezzo() {
        return prezzo * (100 - scontoPercentuale) / 100;
    }
}
