/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.lingprog.esame1906;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;

public abstract class Tile
extends StackPane
implements Comparable {
    Shape s;
    Text tileText;
    int tileNumber;
    EventHandler<MouseEvent> controller = null;

    Tile(int i, Shape s, EventHandler<MouseEvent> vc, Color c) {
        this.s = s;
        s.setFill((Paint)c);
        s.setStroke((Paint)c.invert());
        this.tileNumber = i;
        this.tileText = new Text("" + i);
        this.tileText.setStroke((Paint)c.invert());
        this.getChildren().addAll((Object[])new Node[]{s, this.tileText});
        this.controller = vc;
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, this.controller);
    }

    public void makeInactive() {
        this.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.controller);
    }

    public boolean isEquivalent(Tile obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return false;
        }
        return this.getClass() == obj.getClass() && this.tileNumber == obj.tileNumber;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Tile) {
            Tile t = (Tile)obj;
            return t.tileNumber - this.tileNumber;
        }
        return 0;
    }

    public abstract void update();

    public abstract int getDesiredPosition();
}

