/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.lingprog.esame1906;

import it.unitn.disi.lingprog.esame1906.CircleTile;
import it.unitn.disi.lingprog.esame1906.Esame1906;
import it.unitn.disi.lingprog.esame1906.SquareTile;
import it.unitn.disi.lingprog.esame1906.Tile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class VerticalContainer
extends VBox
implements EventHandler<MouseEvent> {
    final ArrayList<Tile> listaDiTiles = new ArrayList();
    Esame1906 app;

    VerticalContainer(Esame1906 app) {
        this.app = app;
    }

    public void populate(int n) {
        Random rg = new Random(System.currentTimeMillis());
        while (this.listaDiTiles.size() < n) {
            Color c = new Color(rg.nextDouble(), rg.nextDouble(), rg.nextDouble(), 1.0);
            int k = rg.nextInt(10);
            boolean isOk = true;
            Tile t = null;
            t = this.listaDiTiles.size() < n / 2 ? new CircleTile(k, this, c) : new SquareTile(k, this, c);
            for (Tile t1 : this.listaDiTiles) {
                if (!t.isEquivalent(t1)) continue;
                isOk = false;
                break;
            }
            if (!isOk) continue;
            this.listaDiTiles.add(t);
        }
        Collections.shuffle(this.listaDiTiles);
        this.getChildren().addAll(this.listaDiTiles);
    }

    void sort() {
        this.getChildren().removeAll(this.listaDiTiles);
        Collections.sort(this.listaDiTiles);
        this.getChildren().addAll(this.listaDiTiles);
    }

    Tile checkForDuplicates(Tile thisTile) {
        Tile duplicateTile = null;
        for (Tile aTile : this.listaDiTiles) {
            if (!thisTile.isEquivalent(aTile)) continue;
            duplicateTile = aTile;
            break;
        }
        return duplicateTile;
    }

    void remove(Tile thisTile) {
        this.listaDiTiles.remove(thisTile);
        this.app.hbox.getChildren().add((Object)thisTile);
        thisTile.makeInactive();
    }

    void reposition(Tile thisTile) {
        this.listaDiTiles.remove(thisTile);
        int desiredPosition = thisTile.getDesiredPosition();
        if (desiredPosition == 0) {
            this.listaDiTiles.add(0, thisTile);
        }
        if (desiredPosition == 1) {
            this.listaDiTiles.add(thisTile);
        }
    }

    public void handle(MouseEvent event) {
        this.performAction((Tile)event.getSource());
        event.consume();
    }

    private void performAction(Tile tile) {
        this.getChildren().removeAll(this.listaDiTiles);
        tile.update();
        Tile duplicate = this.checkForDuplicates(tile);
        if (duplicate != null) {
            this.remove(tile);
            this.remove(duplicate);
        } else {
            this.reposition(tile);
        }
        this.getChildren().addAll(this.listaDiTiles);
    }

    void push(int n) {
        boolean foundOne = false;
        for (Tile t : this.listaDiTiles) {
            if (t.tileNumber != n) continue;
            this.performAction(t);
            foundOne = true;
            break;
        }
        if (foundOne) {
            this.push(n);
        }
    }
}

