package it.unitn.disi.lingprog.esame1909;

import it.unitn.disi.lingprog.esame1909.caselle.Casella;
import it.unitn.disi.lingprog.esame1909.caselle.CasellaDUE;
import it.unitn.disi.lingprog.esame1909.caselle.CasellaTRE;
import java.util.Random;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;

/**
 * Griglia contenente le caselle
 * @author ronchet
 */
public class Griglia extends GridPane {

    final int N = 3;
    Color color;
    Casella[][] caselle;

    /**
     * Costruttore
     *
     * @param n numero di celle per riga/colonna
     * @param cellController Controllore degli esenti di mouse per le caselle
     */
    Griglia() {
        Random randomGenerator = new Random(System.currentTimeMillis());
        caselle = new Casella[N][N];
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < N; j++) {
                int r = randomGenerator.nextInt(2);
                if (r == 0)
                    caselle[i][j] = new CasellaTRE();
                else
                    caselle[i][j] = new CasellaDUE();
                //aggiungi la casella alla griglia grafica
                this.add(caselle[i][j], i, j);
            }
        }
    }
    /**
     * svuota tutte le caselle
     */
    public void clearAll() {
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < N; j++) {
                caselle[i][j].clear();
            }
        }
    }
    /**
     * Calcola un intero usando i valori delle celle, e 
     * desumine se la riga/colonna è composta di elementi omogenei
     * @return l'informazione su quale riga/colonna contenga elementi uguali
     */
    private String compute() {
        // controllo sulle righe
        for (int j = 0; j < N; j++) {
            int sum=0;
            for (int i = 0; i < N; i++) {
                sum=sum+caselle[i][j].getValue();
            }
            switch (sum) {
                case 30:
                    return "Riga "+(j+1)+" (Cerchi)";
                case 300:
                    return "Riga "+(j+1)+" (Triangoli)";
            }
            System.out.println(j+" "+sum);
        }
        // controllo sulle colonne
        for (int i = 0; i < N; i++) {
            int sum=0;
            for (int j = 0; j < N; j++) {
                sum=sum+caselle[i][j].getValue();
            }
            switch (sum) {
                case 30:
                   return "Colonna "+(i+1)+" (Cerchi)";
                case 300:
                   return "Colonna "+(i+1)+" (Triangoli)";
            }
        }
        return null;
    }
    /**
     * controlla se vi sono righe/colonne uguali e comunicalo tramite un Alert
     */
    public void check() {
        String r=compute();
        Alert alert = new Alert(AlertType.INFORMATION);
        alert.setTitle("Information Dialog");
        alert.setHeaderText("Risultato del controllo:");
        if (r != null) {
            alert.setContentText("Tre uguali : " + r);
            System.out.println("Tre uguali : " + r);
        } else {
            alert.setContentText("Nessun risultato utile");
            System.out.println("Nessun risultato utile");
        }
        alert.showAndWait();
    }
}
