package it.unitn.disi.lingprog.esame1909.caselle;

import it.unitn.disi.lingprog.esame1909.figure.Cerchio;
import it.unitn.disi.lingprog.esame1909.figure.Empty;
import it.unitn.disi.lingprog.esame1909.figure.Figura;
import it.unitn.disi.lingprog.esame1909.figure.Triangolo;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

/**
 * Classe base per le caselle
 * @author ronchet
 */
public abstract class Casella extends BorderPane {

    Figura figura = null;
    Button clear = new Button();
    Figura empty=new Empty();
    Figura cerchio=new Cerchio();
    Figura triangolo=new Triangolo();
    HBox bottoni=new HBox();
    public Casella() {
        this.setPrefSize(100,100);
        figura=empty;
        clear.setText("C");
        clear.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
               clear();
            }
        });
        bottoni.getChildren().add(clear);
        bottoni.setAlignment(Pos.CENTER);
        setBottom(bottoni);
        this.setOnMouseClicked(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent event) {
               clear();
            }
        });
    }
    /**
     * cancella la figura contenuta nella casella, 
     * rimpiazzandola con la figura fuota
     */
    public void clear() {
        figura=empty;
        setCenter(figura.getNode());
    }
    /**
     * Ottieni il valore della figura
     * @return valore della figura
     */
    public int getValue() {
        return figura.getValue();
    }
}
