package it.unitn.disi.lingprog.esame1909.figure;

import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape;

/**
 * classe astratta che rappresentante una figura generica
 * Alle figure è associato un valore (definito nelle sottoclassi:
 * 0 per la vuota, 10 per il cerchio, 100 per il triangolo) 
 * così da poter determinare in modo semplice ed aritmetico 
 * se una riga/colonna della griglia è composta di elementi 
 * uguali o meno.
 * @author ronchet
 */
public abstract class Figura {
    /**
     * lo shape che caratterizza la figura 
     **/
    Shape content=null;
    int value;
    /**
     * metodo che setta i colori per lo shape
     */
    public void paintContent(){
        content.setFill(Color.YELLOW);
        content.setStroke(Color.RED);
    }
    /**
     * recupera lo Shape collegato alla figura
     * Restituirlo come Node lascia aperta la porta a possibili implementazioni alternative
     * @return lo Shape collegato alla figura
     */
    public Node getNode() {return content;}
    public int getValue() {return value;}
}

