/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.prog2.ronchet.esame2001;

import it.unitn.disi.prog2.ronchet.esame2001.Auto;
import it.unitn.disi.prog2.ronchet.esame2001.cells.Cell;
import it.unitn.disi.prog2.ronchet.esame2001.cells.CellController;
import it.unitn.disi.prog2.ronchet.esame2001.cells.Prato;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaE;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaN;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaO;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaS;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;

public class Griglia
extends GridPane {
    final int N;
    Color color;
    Cell[][] caselle;
    CellController cellController = null;

    public Griglia(int n, CellController cellController) {
        this.N = n;
        this.cellController = cellController;
        this.caselle = new Cell[this.N][this.N];
        for (int i = 0; i < this.N; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.caselle[i][j] = new Prato(i, j);
                this.add((Node)this.caselle[i][j], i, j);
                this.caselle[i][j].setController(cellController);
            }
        }
    }

    public void replaceCell(int i, int j, String type) {
        Cell newCell = null;
        switch (type) {
            case "N": {
                newCell = new StradaN(i, j);
                break;
            }
            case "S": {
                newCell = new StradaS(i, j);
                break;
            }
            case "E": {
                newCell = new StradaE(i, j);
                break;
            }
            case "O": {
                newCell = new StradaO(i, j);
                break;
            }
            case "P": {
                newCell = new Prato(i, j);
            }
        }
        newCell.setController(this.cellController);
        this.caselle[i][j] = newCell;
        this.add((Node)this.caselle[i][j], i, j);
    }

    void moveAuto(int destinationX, int destinationY, Auto auto) {
        if (this.caselle[destinationX][destinationY] instanceof Prato) {
            System.out.println("Crash - non puoi portare una macchina su un prato!");
        } else {
            this.caselle[destinationX][destinationY].addAuto(auto);
        }
    }
}

