package it.unitn.disi.prog2.ronchet.esame2001;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;

/**
 * Controllore per i bottoni della gui
 * @author ronchet
 */
public class ButtonsController implements EventHandler<ActionEvent> {

    Esame2001 esame2001;
    Auto auto;

    public ButtonsController(Esame2001 e) {
        esame2001 = e;
    }

    @Override
    public void handle(ActionEvent event) {
        Button source = (Button) event.getSource();
        String id = source.getId();
        switch (id) {
            case "A":
                addAuto();
                break;
            case "M":
                moveAuto();
                break;
            case "R":
                reset();
                break;
            default:
                enable1stGroupButtons();
                selectSource(source);
        }
    }

    private void enable1stGroupButtons() {
        for (Button tb : esame2001.buttonFirstGroup) {
            tb.setDisable(false);
        }
    }
    /**
     * Memorizza in esame2001 la scelta corrente
     * @param source 
     */
    private void selectSource(Button source) {
        source.setDisable(true);
        esame2001.setSelectedType(source.getId());
    }

    public void setupButtons() {
        for (Button button : esame2001.buttonFirstGroup) {
            button.addEventFilter(ActionEvent.ACTION, this);
            button.setPrefWidth(110);
        }
    }

    void setAuto(Auto auto) {
        this.auto = auto;
    }
    void addAuto() {
        esame2001.setSelectedType("A");
        esame2001.moveAutoButton.setDisable(false);
        esame2001.addAutoButton.setDisable(true); 
        //disable1stGroupButtons();
    }
    void moveAuto(){
        int deltaX=auto.getCurrentCell().getDeltaX();
        int deltaY=auto.currentCell.getDeltaY();
        boolean fail=(deltaX==0 && deltaY==0);
        int destinationX=auto.getCurrentCell().getPosX()+deltaX;
        fail=fail|| destinationX<0 || destinationX>=esame2001.dimGriglia; 
        int destinationY=auto.getCurrentCell().getPosY()+deltaY;
        fail=fail|| destinationY<0 || destinationY>=esame2001.dimGriglia; 
        if (fail) { 
            System.out.println("Crash - Impossibile muovere l'auto");
        } else {
            esame2001.griglia.moveAuto(destinationX, destinationY, auto);
        }
    }
    void reset(){
        enable1stGroupButtons();
        auto.currentCell.getChildren().remove(auto);
        esame2001.moveAutoButton.setDisable(true);
        esame2001.addAutoButton.setDisable(false); 
    };
}
