package it.unitn.disi.prog2.ronchet.esame2001;

import it.unitn.disi.prog2.ronchet.esame2001.cells.Cell;
import it.unitn.disi.prog2.ronchet.esame2001.cells.CellController;
import java.util.Collection;
import java.util.HashSet;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

/**
 *
 * @author ronchet
 */
public class Esame2001 extends Application {

    String selectedType = "P";
    public Griglia griglia=null;
    Button nButton = new Button("Strada  NORD");
    Button sButton = new Button("Strada   SUD");
    Button eButton = new Button("Strada   EST");
    Button oButton = new Button("Strada OVEST");
    Button pButton = new Button("   PRATO    ");
    Collection<Button> buttonFirstGroup = new HashSet<>();
    Button addAutoButton = new Button("Aggiungi auto");
    public Button moveAutoButton = new Button("Muovi auto");
    Button resetButton = new Button("Reset");
    Auto auto=new Auto();
    public int dimGriglia = 10;

    @Override
    public void start(Stage primaryStage) {
        // setup bottoni primo gruppo ================
        nButton.setId("N");
        buttonFirstGroup.add(nButton);
        sButton.setId("S");
        buttonFirstGroup.add(sButton);
        eButton.setId("E");
        buttonFirstGroup.add(eButton);
        oButton.setId("O");
        buttonFirstGroup.add(oButton);
        pButton.setId("P");
        buttonFirstGroup.add(pButton);
        ButtonsController buttonsController = new ButtonsController(this);
        buttonsController.setupButtons();
        buttonsController.setAuto(auto);
        //--
        GridPane cb_gp = new GridPane();
        cb_gp.add(nButton, 1, 0);
        cb_gp.add(sButton, 1, 2);
        cb_gp.add(oButton, 0, 1);
        cb_gp.add(eButton, 2, 1);
        cb_gp.add(pButton, 1, 1);
        // setup bottoni secondo gruppo ================
        addAutoButton.setPrefWidth(110);
        addAutoButton.setId("A");
        addAutoButton.addEventHandler(ActionEvent.ACTION, buttonsController);
        moveAutoButton.setPrefWidth(110);
        moveAutoButton.setId("M");
        moveAutoButton.addEventHandler(ActionEvent.ACTION, buttonsController);
        moveAutoButton.setDisable(true);
        resetButton.setPrefWidth(110);
        resetButton.setId("R");
        resetButton.addEventHandler(ActionEvent.ACTION, buttonsController);
        //---      
        GridPane ob_gp = new GridPane();
        ob_gp.add(addAutoButton, 0, 0);
        ob_gp.add(moveAutoButton, 0, 1);
        ob_gp.add(resetButton, 0, 2);
        // ================
        KeyController keyController=new KeyController(this);
        BorderPane root = new BorderPane();
        root.addEventHandler(KeyEvent.KEY_TYPED, keyController);
        root.setStyle("-fx-background-color: #888888;");
        CellController cellsController = new CellController(this);
        cellsController.setAuto(auto);
        griglia = new Griglia(dimGriglia, cellsController);
        root.setCenter(griglia);
        //
        GridPane gp = new GridPane();
        gp.add(cb_gp,0,0);
        gp.add(ob_gp,1,0);
        gp.setMargin(cb_gp, new Insets(1,20,1,1));
        root.setBottom(gp);       
        //--
        int grigliaSize = dimGriglia * Cell.DIM;
        Scene scene = new Scene(root, grigliaSize, grigliaSize + 100);
        //--
        primaryStage.setTitle("Make a road!");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public void setSelectedType(String s){
        selectedType=s;
    }
    public String getSelectedType(){
        return selectedType;
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
}
