package it.unitn.disi.prog2.ronchet.esame2001;

import it.unitn.disi.prog2.ronchet.esame2001.cells.Cell;
import it.unitn.disi.prog2.ronchet.esame2001.cells.CellController;
import it.unitn.disi.prog2.ronchet.esame2001.cells.Prato;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaE;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaO;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaN;
import it.unitn.disi.prog2.ronchet.esame2001.cells.StradaS;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;

/**
 * Griglia su cui si costruisce il tracciato
 *
 * @author ronchet
 */
public class Griglia extends GridPane {

    final int N;
    Color color;
    Cell[][] caselle;
    CellController cellController = null;

    /**
     * Costruttore
     *
     * @param n numero di celle per riga/colonna
     * @param cellController Controllore degli esenti di mouse per le caselle
     */
    public Griglia(int n, CellController cellController) {
        N = n;
        this.cellController = cellController;
        caselle = new Cell[N][N];
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < N; j++) {
                caselle[i][j] = new Prato(i, j);
                //aggiungi la casella alla griglia grafica
                this.add(caselle[i][j], i, j);
                caselle[i][j].setController(cellController);
            }
        }
    }

    public void replaceCell(int i, int j, String type) {
        Cell newCell = null;
        switch (type) {
            case "N":
                newCell = new StradaN(i, j);
                break;
            case "S":
                newCell = new StradaS(i, j);
                break;
            case "E":
                newCell = new StradaE(i, j);
                break;
            case "O":
                newCell = new StradaO(i, j);
                break;
            case "P":
                newCell = new Prato(i, j);
                break;
        }
        newCell.setController(cellController);
        caselle[i][j] = newCell;
        this.add(caselle[i][j], i, j);
    }

    void moveAuto(int destinationX, int destinationY, Auto auto) {
        if (caselle[destinationX][destinationY] instanceof Prato) {
            System.out.println("Crash - non puoi portare una macchina su un prato!");
        } else {
            caselle[destinationX][destinationY].addAuto(auto);
        }
    }
}
