package it.unitn.disi.prog2.ronchet.esame2001.cells;

import it.unitn.disi.prog2.ronchet.esame2001.Auto;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

/**
 * Classe che rappresenta una cella generica
 * @author ronchet
 */
public abstract class Cell extends StackPane {

    /**
     *
     */
    static public final int DIM=50;
    int posX;
    int posY;
    Rectangle square;

    /**
     * Costruttore
     * @param i coordinata della cella 
     * @param j coordinata della cella
     * @param color colore della cella
     */
    public Cell(int i,int j, Color color) {
        setPosX(i);
        setPosY(j);
        square=new Rectangle(DIM-2,DIM-2);
        square.setFill(color);
        setMargin(square, new Insets(1,1,1,1));
        this.getChildren().add(square);
    }

    /**
     * Setter per il controller
     * @param controller
     */
    public void setController (CellController controller){
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, controller);
    }

    /**
     * getter  
     * @return la posizione X della cella
     */
    public int getPosX() {return posX;}

    /**
     * getter 
     * @return la posizione Y della cella
     */
    public int getPosY() {return posY;}
    private void setPosX(int k) {posX=k;}
    private void setPosY(int k) {posY=k;}

    /**
     * Aggiungi l'auto sulla cella
     * @param auto
     */
    public abstract void addAuto(Auto auto);

    /**
     * Dá la componente X dello spostamento che si avrà muovendo l'auto
     * @return lo spostamento lungo X 
     */
    public int getDeltaX() {
        return 0; //To change body of generated methods, choose Tools | Templates.
    }

    /**
     * Dá la componente Y dello spostamento che si avrà muovendo l'auto
     * @return o spostamento lungo X 
     */
    public int getDeltaY() {
        return 0; //To change body of generated methods, choose Tools | Templates.
    }
}
