package it.unitn.disi.prog2.ronchet.esame2001.cells;

import it.unitn.disi.prog2.ronchet.esame2001.Auto;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

/**
 * Sottoclasse di Cell che rappresenta una strada generica 

 * @author ronchet
 */
public abstract class Strada extends Cell {
    BorderPane bp=new BorderPane();
    Circle circle=new Circle();
    int radius=5;

    /**
     * Costruttore
     * @param i componente x della cella
     * @param j componente y della cella
     */
    public Strada(int i, int j) {
        super(i,j,Color.GRAY);
        bp.setStyle("-fx-background-color: #666666;");
        circle.setRadius(radius);
        circle.setStroke(Color.YELLOW);
        bp.setAlignment(circle,Pos.CENTER);
        this.setMargin(bp, new Insets(1,1,1,1));
    }
    /**
     * aggiungi un auto sulla cella
     * @param auto 
     */
    public void addAuto(Auto auto) {
        this.getChildren().add(auto);
        auto.setCurrentCell(this);
    }
}
