/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.ronchet.esamefebbraio21;

import it.unitn.ronchet.esamefebbraio21.artists.Artist;
import it.unitn.ronchet.esamefebbraio21.artists.ArtistSetCreator;
import it.unitn.ronchet.esamefebbraio21.artists.Painter;
import it.unitn.ronchet.esamefebbraio21.artists.Writer;
import it.unitn.ronchet.esamefebbraio21.cells.AbstractCell;
import it.unitn.ronchet.esamefebbraio21.cells.ImageCell;
import it.unitn.ronchet.esamefebbraio21.cells.TextCell;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.stage.Stage;

public class EsameFebbraio21
extends Application {
    TilePane column1 = new TilePane();
    TilePane column2 = new TilePane();
    TilePane column3 = new TilePane();

    public void start(Stage primaryStage) {
        ArtistSetCreator ac = new ArtistSetCreator();
        Set<Artist> collection = ac.randomSelect(3);
        HBox hb = new HBox();
        this.column1.setPrefColumns(1);
        this.column2.setPrefColumns(1);
        this.column3.setPrefColumns(1);
        hb.getChildren().addAll((Object[])new Node[]{this.column1, this.column2, this.column3});
        hb.setAlignment(Pos.CENTER);
        LinkedList<TextCell> nomeList = new LinkedList<TextCell>();
        LinkedList<TextCell> cognomeList = new LinkedList<TextCell>();
        LinkedList<ImageCell> operaList = new LinkedList<ImageCell>();
        for (Artist artist : collection) {
            AbstractCell tc1;
            nomeList.add(new TextCell(artist, artist.nome));
            cognomeList.add(new TextCell(artist, artist.cognome));
            if (artist instanceof Painter) {
                String imageFile = ((Painter)artist).imageFile;
                tc1 = new ImageCell(artist, imageFile);
                operaList.add((ImageCell)tc1);
                continue;
            }
            if (!(artist instanceof Writer)) continue;
            String incipit = ((Writer)artist).incipit;
            tc1 = new TextCell(artist, incipit);
            operaList.add((ImageCell)tc1);
        }
        Collections.shuffle(operaList);
        for (AbstractCell abstractCell : operaList) {
            this.column1.getChildren().add((Object)abstractCell);
        }
        Collections.sort(cognomeList);
        for (TextCell textCell : cognomeList) {
            this.column2.getChildren().add((Object)textCell);
        }
        Collections.shuffle(cognomeList);
        for (TextCell textCell : nomeList) {
            this.column3.getChildren().add((Object)textCell);
        }
        Button btn = new Button();
        btn.setText("Check");
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String msg = "Hai perso!";
                if (EsameFebbraio21.this.check()) {
                    msg = "Hai vinto!";
                }
                Alert alert = new Alert(Alert.AlertType.INFORMATION, msg, new ButtonType[]{ButtonType.OK});
                alert.showAndWait();
                Platform.exit();
                System.exit(0);
            }
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)hb);
        borderPane.setBottom((Node)btn);
        BorderPane.setAlignment((Node)btn, (Pos)Pos.CENTER);
        Scene scene = new Scene((Parent)borderPane, 600.0, 500.0);
        primaryStage.setTitle("Nome Cognome");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    boolean check() {
        Artist selectedArtist = null;
        for (Object n : this.column1.getChildren()) {
            AbstractCell cell = (AbstractCell)n;
            if (!cell.isSelected) continue;
            if (selectedArtist == null) {
                selectedArtist = cell.artista;
                continue;
            }
            return false;
        }
        String selectedCognome = null;
        for (Node n : this.column2.getChildren()) {
            TextCell cell = (TextCell)n;
            if (!cell.isSelected) continue;
            if (selectedCognome == null) {
                selectedCognome = cell.artista.cognome;
                continue;
            }
            return false;
        }
        if (selectedCognome == null || !selectedCognome.equals(selectedArtist.cognome)) {
            return false;
        }
        String selectedNome = null;
        for (Node n : this.column3.getChildren()) {
            TextCell cell = (TextCell)n;
            if (!cell.isSelected) continue;
            if (selectedNome == null) {
                selectedNome = cell.artista.nome;
                continue;
            }
            return false;
        }
        return selectedNome != null && selectedNome.equals(selectedArtist.nome);
    }

    public static void main(String[] args) {
        EsameFebbraio21.launch((String[])args);
    }
}

