package it.unitn.ronchet.esamefebbraio21;

import it.unitn.ronchet.esamefebbraio21.artists.Artist;
import it.unitn.ronchet.esamefebbraio21.artists.Writer;
import it.unitn.ronchet.esamefebbraio21.artists.Painter;
import it.unitn.ronchet.esamefebbraio21.artists.ArtistSetCreator;
import it.unitn.ronchet.esamefebbraio21.cells.AbstractCell;
import it.unitn.ronchet.esamefebbraio21.cells.ImageCell;
import it.unitn.ronchet.esamefebbraio21.cells.TextCell;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.stage.Stage;

public class EsameFebbraio21 extends Application {
    TilePane column1 = new TilePane();
    TilePane column2 = new TilePane();
    TilePane column3 = new TilePane();

    @Override
    public void start(Stage primaryStage) {
        // leggi tutti i dati
        ArtistSetCreator ac = new ArtistSetCreator();
        // seleziona i dati da mostrare
        Set<Artist> collection = ac.randomSelect(3);
        // crea una griglia composta di tre TilPane disposti a colonna
        HBox hb = new HBox();
        column1.setPrefColumns(1);
        column2.setPrefColumns(1);
        column3.setPrefColumns(1);
        hb.getChildren().addAll(column1, column2, column3);
        hb.setAlignment(Pos.CENTER);
        // crea e popola le liste di celle da usare
        List<TextCell> nomeList = new LinkedList();
        List<TextCell> cognomeList = new LinkedList();
        List<AbstractCell> operaList = new LinkedList();
        for (Artist a : collection) {
            nomeList.add(new TextCell(a,a.nome));
            cognomeList.add(new TextCell(a,a.cognome));
            if (a instanceof Painter) {
                String imageFile = ((Painter) a).imageFile;
                ImageCell tc1 = new ImageCell(a,imageFile);
                operaList.add(tc1);
        } else if (a instanceof Writer) {
                String incipit = ((Writer) a).incipit;
                TextCell tc1 = new TextCell(a,incipit);
                operaList.add(tc1);
            }
        }
        // ordina o mescola le colonne
        Collections.shuffle(operaList);
        for (AbstractCell cell : operaList) {
            column1.getChildren().add(cell);
        }
        Collections.sort(cognomeList);
         for (TextCell cell : cognomeList) {
            column2.getChildren().add(cell);
        }
        Collections.shuffle(cognomeList);
         for (TextCell cell : nomeList) {
            column3.getChildren().add(cell);
        }        
        // prepara il bottone per il controllo
        Button btn = new Button();
        btn.setText("Check");
        btn.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                String msg="Hai perso!";
                if (check()) msg="Hai vinto!";
                Alert alert = new Alert(Alert.AlertType.INFORMATION, msg, ButtonType.OK);
                alert.showAndWait();
                Platform.exit();
                System.exit(0);
            }
        });
        // crea il pannello principale e disponici le componenti
        BorderPane root = new BorderPane();
        root.setCenter(hb);
        root.setBottom(btn);
        BorderPane.setAlignment(btn, Pos.CENTER);
        Scene scene = new Scene(root, 600, 500);
        primaryStage.setTitle("Nome Cognome");
        primaryStage.setScene(scene);
        primaryStage.show();
    }
    boolean check() {
        // controllo su colonna 1
        Artist selectedArtist=null;
        for (Node n : column1.getChildren()) {
            AbstractCell cell=(AbstractCell)n;
            if (cell.isSelected) {
                if (selectedArtist==null) {
                    selectedArtist=cell.artista;
                } else {
                    // c'era già un selectedArtist, non possono esserci due celle selezionate dello stesso tipo!
                    return false;  
                }
            }
        }
        //
        // controllo su colonna 2
        String selectedCognome=null;
        for (Node n : column2.getChildren()) {
            TextCell cell=(TextCell)n;
            if (cell.isSelected) {
                if (selectedCognome==null) {
                    selectedCognome=cell.artista.cognome;
                } else {
                    // c'era già un selectedCognome, non possono esserci due celle selezionate dello stesso tipo!
                    return false;  
                }
            }
        }
        // se il cognome non coincide con quello dell'artista selezionato, hai perso
        if (selectedCognome==null||!selectedCognome.equals(selectedArtist.cognome)) return false;
        //
        // controllo su colonna 3
        String selectedNome=null;
        for (Node n : column3.getChildren()) {
            TextCell cell=(TextCell)n;
            if (cell.isSelected) {
                if (selectedNome==null) {
                    selectedNome=cell.artista.nome;
                } else {
                    // c'era già un selectedNome, non possono esserci due celle selezionate dello stesso tipo!
                    return false;  
                }
            }
        }
        // se il cognome non coincide con quello dell'artista selezionato, hai perso
        if (selectedNome==null||!selectedNome.equals(selectedArtist.nome)) return false;
        // se giungi qui, hai passato tutti i controlli
        return true;
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }

}
