package it.unitn.ronchet.esamefebbraio21.artists;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
/**
 * Classe per la creazione dei dati
 */
public class ArtistSetCreator {
    Writer manzoni = new Writer("Alessandro", "Manzoni", "Quel ramo del lago di Como, che volge a mezzogiorno, tra due catene non interrotte di monti, tutto a seni e a golfi…");
    Writer dante = new Writer("Dante", "Alighieri", "Nel mezzo del cammin di nostra vita mi ritrovai per una selva oscura…");
    Writer pavese = new Writer("Cesare", "Pavese", "C'è una ragione perché sono tornato in questo paese, qui e non invece a Canelli, a Barbaresco o in Alba. ");
    Painter caravaggio = new Painter("Michelangelo", "Merisi", "Fanciullo.jpg");
    Painter michelangelo = new Painter("Michelangelo", "Buonarroti", "Adamo.jpg");
    Painter boccioni = new Painter("Umberto", "Boccioni", "Addii.jpg");
    List<Artist> collection;
    Random randomGenerator=new Random();
    public ArtistSetCreator(){
      create();
      randomGenerator.setSeed(System.currentTimeMillis());
    }
    public void create() {
       collection=new LinkedList<Artist>();
       collection.add(manzoni);
       collection.add(dante);
       collection.add(pavese);
       collection.add(caravaggio);
       collection.add(michelangelo);
       collection.add(boccioni);
    }
    /**
     * seleziona in modo casuale un sottoinsieme di artisti, senza ripetizioni
     * @param n numero di artisti da selezionare
     * @return 
     */
    public Set<Artist> randomSelect(int n) {
        Set<Artist> theSet=new HashSet();
        int added=0;
        do {
            Artist nextCandidate=collection.get(randomGenerator.nextInt(collection.size()));
            if (theSet.add(nextCandidate)) added++;
        } while (added<n);
        return theSet;
    }
    /**
     * main per lo unit testing
     * @param args 
     */
    public static void main(String args[]){
        ArtistSetCreator ac=new ArtistSetCreator();
        Set<Artist> set=ac.randomSelect(3);
        for (Artist a:set) {
            System.out.println(a.cognome);
        }
    }
}
