package it.unitn.ronchet.esamefebbraio21.cells;

import it.unitn.ronchet.esamefebbraio21.artists.Artist;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

public class AbstractCell extends StackPane implements Comparable {
    public Rectangle rect;
    public Artist artista;
    public boolean isSelected=false;
    public String value;

    public AbstractCell(Artist a, String value) {
        artista=a;
        this.value=value;
        rect = new Rectangle(150, 150);
        rect.setFill(Color.YELLOW);
        rect.setStroke(Color.BLUE);
        this.setOnMouseClicked(new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent event) {
                if (rect.getFill().equals(Color.YELLOW)) {
                   rect.setFill(Color.ALICEBLUE);
                   isSelected=true;
                } else {
                    rect.setFill(Color.YELLOW);
                    isSelected=false;
                }
            }
        });
    }
    public String getValue() {return value;}
    @Override
    public int compareTo(Object a) {
        // non gestiamo esplicitamente il caso in cui a non sia un Artist
        return value.compareTo(((AbstractCell)a).value);   
    }
}

