package it.unitn.lingProg.ronchet.esercitazione3a;

import java.util.Objects;

public class Carta implements Comparable {
    String valore;
    String seme;

    public Carta(String seme, String valore) {
        this.valore = valore;
        this.seme = seme;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.valore);
        hash = 89 * hash + Objects.hashCode(this.seme);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final Carta other = (Carta) obj;
        if (!Objects.equals(this.valore, other.valore))
            return false;
        if (!Objects.equals(this.seme, other.seme))
            return false;
        return true;
    }
    

    @Override
    public String toString() {
        return "[" + valore + "," + seme + ']';
    }

    @Override
    public int compareTo(Object obj) {
        if (this == obj)
            return 0;
        if (obj == null || getClass() != obj.getClass())
            System.err.println("Error in compareTo " + obj);
        final Carta other = (Carta) obj;
        int v_comp = this.valore.compareTo(other.valore);
        if (v_comp != 0)
            return v_comp;
        //int s_comp = seme.compareTo(other.seme);
       int s_comp=getValue(other.seme)-getValue(this.seme);
        return s_comp;
    }
    private int getValue(String c) {
        switch (c) {
            case "CUORI": return 1;
            case "QUADRI": return 2;
            case "FIORI": return 3;
            case "PICCHE": return 4;
        }
        return 0;
    }
    
    

    public static void main(String a[]) {
        String c="CUORI";
        String p="PICCHE";
        System.out.println(c+" "+p);
        System.out.println(c+" "+p);
        //System.out.println(c.ordinal()+" "+p.ordinal());
        System.out.println(c.compareTo(p));
        for (String x:new String[] {"CUORI","QUADRI","FIORI","PICCHE"}) {
            System.out.println(x);
        }
        //System.exit(1);
        Carta c1 = new Carta("PICCHE", "K");
        Carta c2 = new Carta("CUORI", "7");
        System.err.println("mi aspetto un output positivo");
        System.out.println(c1.compareTo(c2));
    }
    
}
