
package it.unitn.lingProg.ronchet.esercitazione3a;

import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

/**
 *
 * @author ronchet
 */
public class GraphicApp extends Application {
    // Esempio semplice di rappresentazione grafica dei semi
    @Override
    public void start(Stage primaryStage) {
        Carta c=new Esercitazione3a().esegui();
        if (c==null) System.exit(0);
        System.out.println("Ora disegno "+c);
        String valore=c.valore;
        Group disegnoSeme = new Group();
        Paint color=null;
        switch (c.seme) {
            case "PICCHE":
                color=Paint.valueOf("BLACK");
                Polygon picche=new Polygon(260,80,200,160,320,160);
                disegnoSeme.getChildren().add(picche);
                break;
            case "FIORI":
                color=Paint.valueOf("BLACK");
                Circle circ1 = new Circle(200, 100, 30);   
                Circle circ2 = new Circle(180, 140, 30);   
                Circle circ3 = new Circle(220, 140, 30);   
                disegnoSeme.getChildren().addAll(circ1,circ2,circ3);          
                break;
            case "CUORI":
                color=Paint.valueOf("RED");
                Polygon cuori=new Polygon(200,80,140,160,260,160);
                cuori.setFill(color);
                cuori.setRotate(180);
                disegnoSeme.getChildren().add(cuori);
                break;            
            case "QUADRI":
                color=Paint.valueOf("RED");
                Rectangle quadri=new Rectangle(200,80,80,80);
                quadri.setFill(color);
                quadri.setRotate(45);
                disegnoSeme.getChildren().add(quadri);
                break;
        }
        Text t2=new Text(50, 100, c.valore);      
        t2.setTextAlignment(TextAlignment.LEFT); 
        t2.setFill(color); 
        t2.setFont(new Font(60));
        
        Group root=new Group();
        
        root.getChildren().addAll(t2,disegnoSeme); 
        
        Scene scene = new Scene(root,350,280);
        
        primaryStage.setTitle("Hello World!");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
}
