package it.unitn.lingProg.ronchet.esercitazione3a;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Mazzo extends ArrayList<Carta> {
    /**
     * crea un mazzo contenente n carte per tipo
     * @param n 
     */
    ComparatoreDiCartePerSeme cps=null;
    Mazzo(int n) {
        for (String s : new String[] {"CUORI","QUADRI","FIORI","PICCHE"}) {
            for (String v : new String[] {"1","2","3","4","5","6","7","8","9","_10","_B","_D","_K"}) {
                for (int i = 0; i < n; i++) {   
                    add(new Carta(s, v));
                }
            }
        }
        ComparatoreDiCartePerSeme cps=new ComparatoreDiCartePerSeme();
    }
    
    Mazzo(Mazzo m) {
        this.addAll(m);
    }
    void mescola() {
        Collections.shuffle(this);
    }
    void riordinaPerValore(){
        Collections.sort(this);
    }
    void riordinaPerSeme(){
        Collections.sort(this,cps);
    }

    @Override
    public String toString() {
        String s="";
        for (Carta c:this) {
            s=s.concat(c.toString());
        }
        return "Mazzo{" + s+'}';
    }
    public Carta contieneCarteUguali(){
        // crea una copia del mazzo per poterla riordinare 
        // senza modificare il mazzo di origine
        // se due carte sono uguali, saranno adiacenti nel
        // mazzo riordinato
        Mazzo m = new Mazzo(this);
        //Mazzo m=(Mazzo)(this.clone());
        m.riordinaPerValore();
        Carta prossimaCarta,questaCarta=null;
        Carta doppia=null;
        Iterator<Carta> iter=m.iterator();
        // proteggi dal mazzo vuoto
        if (iter.hasNext()) questaCarta=iter.next();
        while (iter.hasNext()) {
            prossimaCarta=iter.next();
            if (questaCarta.equals(prossimaCarta)){
                doppia=questaCarta;
                break;
            }
            questaCarta=prossimaCarta;
        }
        if (doppia!=null) {
            System.out.println("Hai vinto: Trovato coppia uguale : "+doppia);
        }
        else {
            System.out.println("Hai perso: Non trovato coppia uguale.");
        }
        return doppia;
    }
    public static void main(String a[]){
        Mazzo m=new Mazzo(2);
        m.mescola();
        System.out.println(m);
        System.out.println("====================");
        m.riordinaPerSeme();
        System.out.println(m);
        System.out.println("====================");
        m.riordinaPerValore();
        System.out.println(m);
    }    
}
