/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import javafx.geometry.Pos;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Text;

/**
 * eredita da alloggio tutte le caratteristiche principali, aggiunge quelle di un albergo
 * @author luca.dalforno
 */
public class Albergo extends Alloggio {
    
    private int nStelle;
    
    /**
     * costruttore della classe Albergo
     * @param g riferimento al GestoreAlloggi che lo contiene
     * @param nome nome dell'albergo
     * @param prezzo prezzo dell'albergo
     * @param valutazioneClienti valutazione dell'albergo
     * @param nStelle numero di stelle dell'albergo
     */
    Albergo(GestoreAlloggi g, String nome, double prezzo, double valutazioneClienti, int nStelle)
    {
        super(g, nome,prezzo,valutazioneClienti);
        setnStelle(nStelle);
        HBox stelle=buildStar(nStelle);
        stelle.setAlignment(Pos.CENTER);
        stelle.setSpacing(5.0);
        add(stelle,3,0);
    }

    /**
     * costruisce un'HBox contenente poligoni stellati
     * @param n il numero di stelle
     * @return l'HBox costruita
     */
    private HBox buildStar(int n)
    {
        HBox container=new HBox();
        for(int i=0;i<n;i++)
        {
            Polygon c=new Polygon(7.5,0.0,  13.0,15.0,  0.0,5.0,  15.0,5.0,  2.0,15.0);
            c.setFill(Color.YELLOW);
            container.getChildren().add(c);
        }
        return container;
    }
    
    /**
     * getter del numero di stelle
     * @return il numero di stelle
     */
    public int getnStelle() {
        return nStelle;
    }

    /**
     * setter del numero di stelle
     * @param nStelle il nuovo numero di stelle
     */
    public void setnStelle(int nStelle) {
        if(nStelle>0 && nStelle<6) this.nStelle = nStelle;
        else{
            System.out.println("invalid nStelle value");
            System.exit(1);
        }
    }
    
}
