/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;

/**
 * rappresentazione di un alloggio generico che raggruppa le variabili e i metodi comuni
 * estende GridPane per gestire la parte grafica e organizzare l'alloggio in una riga
 * @author luca.dalforno
 */
public class Alloggio extends GridPane{
    private String nome;
    private double prezzo;
    private double valutazioneClienti;
    
    /**
     * costruttore della classe Alloggio
     * @param g riferimento al GestoreAlloggi che lo contiene
     * @param nome nome dell'alloggio
     * @param prezzo prezzo dell'alloggio
     * @param valutazioneClienti valutazione dell'alloggio
     */
    Alloggio(GestoreAlloggi g, String nome, double prezzo, double valutazioneClienti)
    {
        setNome(nome);
        setPrezzo(prezzo);
        setValutazioneClienti(valutazioneClienti);
        
        setMinWidth(500.0);
        setMaxWidth(500.0);
        
        ColumnConstraints col1=new ColumnConstraints();
        ColumnConstraints col23=new ColumnConstraints();
        ColumnConstraints col4=new ColumnConstraints();
        col1.setPercentWidth(40.0);
        col1.setHalignment(HPos.LEFT);
        col23.setPercentWidth(15.0);
        col23.setHalignment(HPos.RIGHT);
        col4.setPercentWidth(30.0);
        col4.setHalignment(HPos.CENTER);
        getColumnConstraints().addAll(col1,col23,col23,col4);
        Text nomeText=new MyText(getNome());
        Text prezzoText=new MyText(Double.toString(getPrezzo()));
        Text valutazioneText=new MyText(Double.toString(getValutazioneClienti()));
        add(nomeText,0,0);
        add(prezzoText,1,0);
        add(valutazioneText,2,0);
        
        /*
        * costruisco l'event handler associato al click sul nome dell'alloggio, 
        * passando al GestoreAlloggi l'immagine corrispondente
        */
        nomeText.addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>(){
            public void handle(MouseEvent t)
            {
                Image image=new Image("img/"+getNome()+".jpg");
                g.addImage(image);
            }
        });
        
    }
    
    /**
     * getter del nome
     * @return il nome
     */
    public String getNome() {
        return nome;
    }

    /**
     * setter del nome
     * @param nome il nuovo nome
     */
    public void setNome(String nome) {
        this.nome = nome;
    }

    /**
     * getter del prezzo
     * @return il prezzo
     */
    public double getPrezzo() {
        return prezzo;
    }

    /**
     * setter del prezzo
     * @param prezzo il nuovo prezzo
     */
    public void setPrezzo(double prezzo) {
        this.prezzo = prezzo;
    }

    /**
     * getter della valutazione
     * @return la valutazione
     */
    public double getValutazioneClienti() {
        return valutazioneClienti;
    }

    /**
     * setter della valutazione
     * @param valutazioneClienti la nuova valutazione
     */
    public void setValutazioneClienti(double valutazioneClienti) {
        this.valutazioneClienti = valutazioneClienti;
    }
    
}
