/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import javafx.scene.text.Text;

/**
 * eredita da alloggio tutte le caratteristiche principali, aggiunge quelle di un appartamento
 * @author luca.dalforno
 */
public class Appartamento extends Alloggio {
    private int nMaxLetti;
    
    /**
     * costruttore della classe Appartamento
     * @param g riferimento al GestoreAlloggi che lo contiene
     * @param nome nome dell'appartamento
     * @param prezzo prezzo dell'appartamento
     * @param valutazioneClienti valutazione dell'appartamento
     * @param nMaxLetti numero massimo di letti dell'appartamento
     */
    Appartamento(GestoreAlloggi g, String nome, double prezzo, double valutazioneClienti, int nMaxLetti)
    {
        super(g,nome,prezzo,valutazioneClienti);
        setnMaxLetti(nMaxLetti);
        Text letti=new Text("max. persone: " + Integer.toString(getnMaxLetti()));
        add(letti,3,0);
    }

    /**
     * getter del numero massimo di letti
     * @return il numero massimo di letti
     */
    public int getnMaxLetti() {
        return nMaxLetti;
    }

    /**
     * setter del numero massimo di letti
     * @param nMaxLetti il nuovo numero massimo di letti
     */
    public void setnMaxLetti(int nMaxLetti) {
        if(nMaxLetti>1 && nMaxLetti<9) this.nMaxLetti = nMaxLetti;
        else{
            System.out.println("invalid nMaxLetti value");
            System.exit(1);
        }
    }
    
    
}
