/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

/**
 * classe principale del programma, costruisce l'aspetto grafico e contiene alcune funzioni di servizio
 * @author luca.dalforno
 */
public class GestoreAlloggi extends Application {
    
    /**
     * la componente grafica principale che andrà a contenere le altre componenti
     */
    VBox root=new VBox();
    /**
     * contiene l'immagine mostrata al momento
     */
    ImageView currentImageView=null;
    
    @Override
    public void start(Stage primaryStage) {
        
        //==== costruisco la tabella con gli alloggi e i bottoni
        Tabella tabella=new Tabella(this);
        SortButton nome=new SortButton("Nome", tabella, new NameComparator());
        SortButton prezzo=new SortButton("Prezzo", tabella, new PriceComparator());
        SortButton valutazione=new SortButton("Valutazione", tabella, new EvaluationComparator());
        
        //==== costruisco un gridpane per contenere i bottoni, con gli stessi parametri del gridpane di alloggio
        ColumnConstraints col1=new ColumnConstraints();
        ColumnConstraints col23=new ColumnConstraints();
        ColumnConstraints col4=new ColumnConstraints();
        col1.setPercentWidth(40.0);
        col1.setHalignment(HPos.LEFT);
        col23.setPercentWidth(15.0);
        col23.setHalignment(HPos.RIGHT);
        col4.setPercentWidth(30.0);
        col4.setHalignment(HPos.CENTER);
        GridPane buttons=new GridPane();
        buttons.getColumnConstraints().addAll(col1,col23,col23,col4);
        buttons.add(nome, 0, 0);
        buttons.add(prezzo, 1, 0);
        buttons.add(valutazione,2,0);
        
        //==== aggiungo il gestore degli eventi da tastiera. I tasti corrispondenti sono in MAIUSCOLO, come da testo
        EventHandler<KeyEvent> eventHandler=new EventHandler<KeyEvent>(){
            @Override
            public void handle(KeyEvent t) {
                if(!"NPV".contains(t.getCharacter())) t.consume();
                if(t.getCharacter().equals("N")) nome.fireEvent(new ActionEvent());
                if(t.getCharacter().equals("P")) prezzo.fireEvent(new ActionEvent());
                if(t.getCharacter().equals("V")) valutazione.fireEvent(new ActionEvent());
            }
            
        };
        
        root.getChildren().addAll(buttons,tabella);
        Scene scene=new Scene(root,500,520);
        
        scene.addEventHandler(KeyEvent.KEY_TYPED, eventHandler);
        
        primaryStage.setTitle("Dal Forno Luca");
        primaryStage.setScene(scene);
        
        primaryStage.show();
    }

    /**
     * inserisce l'immagine passata sotto alla tabella dopo averne adattato le dimensioni
     * @param image l'immagine da inserire
     */
    public void addImage(Image image)
    {
        removeImageView();
        currentImageView=new ImageView(image);
        currentImageView.setFitWidth(500.0);
        currentImageView.setFitHeight(400.0);
        root.getChildren().add(currentImageView);
        
    }
    
    /**
     * rimuove l'eventuale immagine presente
     */
    public void removeImageView()
    {
        root.getChildren().remove(currentImageView);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
}
