/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import javafx.scene.text.Text;

/**
 * eredita da alloggio tutte le caratteristiche principali, aggiunge quelle di una pensione
 * @author luca.dalforno
 */
public class Pensione extends Alloggio {
    enum Trattamento {SOLO_COLAZIONE, MEZZA_PENSIONE, PENSIONE_COMPLETA}
    Trattamento trattamento;
    
    /**
     * costruttore della classe Pensione
     * @param g riferimento al GestoreAlloggi che lo contiene
     * @param nome nome della pensione
     * @param prezzo prezzo della pensione
     * @param valutazioneClienti valutazione della pensione
     * @param trattamento trattamento della pensione
     */
    Pensione(GestoreAlloggi g, String nome, double prezzo, double valutazioneClienti, Trattamento trattamento)
    {
        super(g,nome,prezzo,valutazioneClienti);
        setTrattamento(trattamento);
        Text trat=new Text(trattamento.toString());
        add(trat,3,0);
    }

    /**
     * getter del trattamento
     * @return il trattamento
     */
    public Trattamento getTrattamento() {
        return trattamento;
    }

    /**
     * setter del trattamento
     * @param trattamento il nuovo trattamento
     */
    public void setTrattamento(Trattamento trattamento) {
        this.trattamento = trattamento;
    }
}
