/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import java.util.Comparator;

/**
 * comparator per effettuare il confronto sul prezzo
 * @author luca.dalforno
 */
public class PriceComparator implements Comparator<Alloggio> {
    /**
     * compara tra loro due alloggi secondo l'ordine crescente di prezzo
     * @param o1 il primo alloggio
     * @param o2 il secondo alloggio
     * @return il risultato della comparazione
     */
    @Override
    public int compare(Alloggio o1, Alloggio o2) {
        if(o1.getPrezzo()==o2.getPrezzo()) return 0;
        if(o1.getPrezzo()<o2.getPrezzo()) return -1;
        return 1;
    }
}
