/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import java.util.Comparator;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;

/**
 * estensione della classe Button per implementare le funzionalità comuni dei bottoni di ordinamento,
 * secondo un determinato comparator
 * @author luca.dalforno
 */
public class SortButton extends Button {
    /**
     * costruttore della classe
     * @param s il testo del bottone
     * @param tab la tabella su cui agisce il bottone
     * @param comp il comparator utilizzato dal bottone per ordinare la tabella
     */
    SortButton(String s, Tabella tab, Comparator<Alloggio> comp)
    {
        super(s);
        addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){
            public void handle(ActionEvent t)
            {
                tab.sortAlloggi(comp);
            }
        });
    }
}
