/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.langProg.dalforno;

import it.unitn.disi.langProg.dalforno.Pensione.Trattamento;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javafx.scene.layout.GridPane;

/**
 * classe che raggruppa i vari alloggi dell'esercizio in un GridPane ad una colonna
 * @author luca.dalforno
 */
public class Tabella extends GridPane{
    /**
     * lista degli alloggi all'interno della tabella
     */
    ArrayList listaAlloggi= new ArrayList<Alloggio>();
    /**
     * numero di alloggi mostrati nella visualizzazione, in ordine di inserimento nella lista
     */
    final int N_SHOWED=5;
    
    /**
     * costruttore della tabella
     * @param g il gestore alloggi associato
     */
    Tabella(GestoreAlloggi g)
    {
        initialize(g);
        addAlloggi();
    }
    
    /**
     * inizializza la tabella con i valori dell'esercizio
     * @param g associa ad ogni alloggio il GestoreAlloggi corrispondente (per il passaggio dell'immagine)
     */
    private void initialize(GestoreAlloggi g)
    {
        listaAlloggi.add(new Pensione(g,"Alpenhof",60,8.5,Trattamento.MEZZA_PENSIONE));
        listaAlloggi.add(new Albergo(g,"Artemide",100,8.4,4));
        listaAlloggi.add(new Pensione(g,"Belste",35,6.2,Trattamento.SOLO_COLAZIONE));
        listaAlloggi.add(new Pensione(g,"Gruber",75,9.3,Trattamento.PENSIONE_COMPLETA));
        listaAlloggi.add(new Albergo(g,"Majestic",65,8.8,3));
        listaAlloggi.add(new Albergo(g,"Palace",200,8.3,5));
        listaAlloggi.add(new Appartamento(g,"PietraBianca",40,9.5,4));
        listaAlloggi.add(new Appartamento(g,"SaporeDiSale",80,7.9,8));
        listaAlloggi.add(new Appartamento(g,"TenutaDiArtimino",60,5.5,6));
        listaAlloggi.add(new Albergo(g,"Zenith",70,6.8,3));
    }
    
    /**
     * aggiunge alla tabella i primi N_SHOWED alloggi della lista
     */
    private void addAlloggi()
    {
        getChildren().clear();
        for(int i=0;i<N_SHOWED;i++)
        {
            add((Alloggio)listaAlloggi.get(i),0,i);
        }
    }
    
    /**
     * riordina gli alloggi utilizzando un determinato comparator
     * @param c il comparator da utilizzare
     */
    public void sortAlloggi(Comparator<Alloggio> c)
    {
        Collections.sort(listaAlloggi, c);
        addAlloggi();
    }
    
}
