/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package unitn.rovereto.folgarait.pierre.alloggi;

import java.util.ArrayList;
import java.util.Comparator;
import javafx.scene.layout.VBox;

/**
 *
 * @author pierre.folgarait
 */
public class Alloggi extends VBox{
    
    ArrayList<Alloggio> strutture;
    mainWindow mW;
    
    /**
     * 
     * @param edifici ArrayList contenente tutti le strutture da mostrare
     * @param main Finestra iniziale
     */
    Alloggi(ArrayList<Alloggio> edifici, mainWindow main){
        strutture = edifici;
        mW = main;
        DisplayArgs();
    }
    
    /**
     * Metodo che stampa sulla finestra iniziale i primi 5 edifici
     */
    public void DisplayArgs(){
        getChildren().clear();
        for (int i = 0; i < 5; i++) {
            getChildren().add(strutture.get(i));
        }
    }
    
    /**
     * Metodo che permette di ordinare tutti gli elementi
     * in ordine decrescente per valutazione assegnata
     */
    public void OrderByValue(){
        strutture.sort(new Comparator<Alloggio>(){
            @Override
            public int compare(Alloggio o1, Alloggio o2) {
                if(o1.valutazione < o2.valutazione) return 1;
                if(o1.valutazione > o2.valutazione) return -1;
                return 0;
            }
        });
    }
    
    
    /**
     * Metodo che permette di ordinare tutti gli elementi
     * in ordine crescente per prezzo
     */
    public void OrderByPrize(){
        strutture.sort(new Comparator<Alloggio>(){
            @Override
            public int compare(Alloggio o1, Alloggio o2) {
                if(o1.prezzo > o2.prezzo) return 1;
                if(o1.prezzo < o2.prezzo) return -1;
                return 0;
            }
        });
    }
    /**
     * Metodo che permette di ordinare tutti gli elementi
     * in ordine alfabetico
     */
    public void OrderByName(){
        strutture.sort(new Comparator<Alloggio>(){
            @Override
            public int compare(Alloggio o1, Alloggio o2) {
                return o1.nome.compareTo(o2.nome);
            }
        });
    }
}
