/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package unitn.rovereto.folgarait.pierre.alloggi;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

/**
 *
 * @author pierre.folgarait
 */
public abstract class Alloggio extends HBox{
    String nome;
    int prezzo;
    double valutazione;
    Label nominativo, costo,recensione;
    mainWindow mW;
    
    /**
     * Costruttore per la classe astratta alloggio
     * @param nome Nome alloggio
     * @param prezzo Prezzo Alloggio
     * @param valutazione Valutazione alloggio
     * @param main Finestra iniziale 
     */
    Alloggio(String nome, int prezzo, double valutazione, mainWindow main){
        this.nome = nome;
        this.prezzo = prezzo;
        if(valutazione >= 6.0 && valutazione <= 10.0)
            this.valutazione = valutazione;
        else
            this.valutazione = 0.0;
        this.setSpacing(30);
        this.setWidth(500);
        mW = main;
        
        nominativo = new Label(this.nome);
        nominativo.setFont(Font.font("Arial", FontWeight.BOLD, 15));
        nominativo.setMinWidth(170);
        costo = new Label("" + this.prezzo);
        costo.setFont(Font.font("Arial", FontWeight.BOLD, 15));
        costo.setMinWidth(30);
        recensione = new Label("" + this.valutazione);
        recensione.setFont(Font.font("Arial", FontWeight.BOLD, 15));
        recensione.setMinWidth(30);
        getChildren().addAll(nominativo, costo, recensione);
        
        addEventHandler(MouseEvent.MOUSE_CLICKED, new EventHandler<MouseEvent>(){
            @Override
            public void handle(MouseEvent event) {
                Image p = new Image("img/" + nome + ".jpg");
                mW.foto.setImage(p);
                
            }
        
    });
    }
}
