/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package unitn.rovereto.folgarait.pierre.alloggi;

import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

/**
 *
 * @author pierre.folgarait
 */
public class mainWindow extends Application {

    VBox root;
    Alloggio Alpenhof, Artemide, Belste, Gruber, Majestic, Palace, PietraBianca, SaporeDiSale, TenutaDiArtimino, Zenith;
    ArrayList<Alloggio> edifici;
    Alloggi villeggiature;
    MyButton ByName, ByPrize, ByValue;
    ImageView foto;

    public enum Servizio {
        SOLA_COLAZIONE,
        MEZZA_PENSIONE,
        PENSIONE_COMPLETA,
    }

    @Override
    public void start(Stage primaryStage) {
        /*Button btn = new Button();
        btn.setText("Say 'Hello World'");
        btn.setOnAction(new EventHandler<ActionEvent>() {
            
            @Override
            public void handle(ActionEvent event) {
                System.out.println("Hello World!");
            }
        });*/

        //Bottoni
        HBox btn = new HBox();
        ByName = new MyButton("Nome", "Nome", false, this);
        ByPrize = new MyButton("Prezzo", "Prezzo", false, this);
        ByPrize.setTranslateX(140);
        ByValue = new MyButton("Valutazione", "Valutazione", false, this);
        ByValue.setTranslateX(140);
        btn.getChildren().addAll(ByName, ByPrize, ByValue);

        //Alloggi
        Alpenhof = new Pensione("Alpenhof", 60, 8.5, Servizio.MEZZA_PENSIONE, this);
        Artemide = new Hotel("Artemide", 100, 8.4, 4, this);
        Belste = new Pensione("Belste", 35, 6.2, Servizio.SOLA_COLAZIONE, this);
        Gruber = new Pensione("Gruber", 75, 9.3, Servizio.PENSIONE_COMPLETA, this);
        Majestic = new Hotel("Majestic", 65, 8.8, 3, this);
        Palace = new Hotel("Palace", 200, 8.3, 5, this);
        PietraBianca = new Appartamento("PietraBianca", 40, 9.5, 4, this);
        SaporeDiSale = new Appartamento("SaporeDiSale", 80, 7.9, 8, this);
        TenutaDiArtimino = new Appartamento("TenutaDiArtimino", 60, 5.5, 6, this);
        Zenith = new Hotel("Zenith", 70, 6.8, 3, this);

        //dichiarazione arrayList
        edifici = new ArrayList<>();

        edifici.add(Artemide);
        edifici.add(Alpenhof);
        edifici.add(Gruber);
        edifici.add(Palace);
        edifici.add(TenutaDiArtimino);
        edifici.add(PietraBianca);
        edifici.add(Majestic);
        edifici.add(SaporeDiSale);
        edifici.add(Zenith);
        edifici.add(Belste);

        villeggiature = new Alloggi(edifici, this);

        //Caricamento foto di default
        foto = new ImageView("img/" + edifici.get(0).nome + ".jpg");

        //Dichiarazione e assegnazione EventHandlers
        EventHandler gestoreBottoni = new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                switch (((MyButton) event.getSource()).getId()) {
                    case "Nome": {
                        villeggiature.OrderByName();
                        villeggiature.DisplayArgs();
                        break;
                    }
                    case "Prezzo": {
                        villeggiature.OrderByPrize();
                        villeggiature.DisplayArgs();
                        break;
                    }
                    case "Valutazione": {
                        villeggiature.OrderByValue();
                        villeggiature.DisplayArgs();
                        break;
                    }
                    default:
                        break;
                }
            }
        };

        for (Node a : btn.getChildren()) {
            if (a instanceof MyButton) {
                a.addEventHandler(ActionEvent.ACTION, gestoreBottoni);
            }
        }

        EventHandler gestoreTastiera = new EventHandler<KeyEvent>() {
            @Override
            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case N: {
                        ByName.fireEvent(new ActionEvent());
                        break;
                    }
                    case P: {
                        ByPrize.fireEvent(new ActionEvent());
                        break;
                    }
                    case V: {
                        ByValue.fireEvent(new ActionEvent());
                        break;
                    }
                }
            }
        };

        primaryStage.addEventHandler(KeyEvent.KEY_PRESSED, gestoreTastiera);

        root = new VBox();
        //root.getChildren().add(btn);
        root.getChildren().addAll(btn, villeggiature, foto);

        Scene scene = new Scene(root, 500, 520);

        primaryStage.setResizable(false);
        primaryStage.setTitle("Pierre Folgarait");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }

}
