/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.lingProg.longato;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

/**
 * La classe principale che si occupa di costruire l'interfaccia primaria e gestire la finestra
 * @author matteo.longato
 */
public class TabellaAlloggi extends Application {
    
    BorderPane baseLayout;
    List<Alloggio> locationsArchive;
    List<TableRecord> currentDisplay;
    ImageDisplayer imageDisplayer;
    
    Table table;
    
    @Override
    public void start(Stage primaryStage) {
        
        baseLayout = new BorderPane();
        
        //Archive building
        locationsArchive = new ArrayList();
        locationsArchive.add(new Pensione("Alpenhof", 60, 8.5, Pensione.Offer.MEZZA_PENSIONE));
        locationsArchive.add(new Hotel("Artemide", 100, 8.4, 4));
        locationsArchive.add(new Pensione("Belste", 35, 6.2, Pensione.Offer.SOLO_COLAZIONE));
        locationsArchive.add(new Pensione("Gruber", 75, 9.3, Pensione.Offer.PENSIONE_COMPLETA));
        locationsArchive.add(new Hotel("Majestic", 65, 8.8, 3));
        locationsArchive.add(new Hotel("Palace", 200, 8.3, 5));
        locationsArchive.add(new Appartamento("PietraBianca", 40, 9.5, 4));
        locationsArchive.add(new Appartamento("SaporeDiSale", 80, 7.9, 8));
        locationsArchive.add(new Appartamento("TenutaDiArtimino", 60, 5.5, 6));
        locationsArchive.add(new Hotel("Zenith", 70, 6.8, 3));
        //
        
        //Top buttons building
        Button name = new Button("Nome");
        Button price = new Button("Prezzo");
        Button grade = new Button("Valutazione");
        
        name.setOnAction((ActionEvent event)->{
            OrderBy(OrderCriteria.NAME);
        });
              
        price.setOnAction((ActionEvent event)->{
            OrderBy(OrderCriteria.PRICE);
        });
        
        grade.setOnAction((ActionEvent event)->{
            OrderBy(OrderCriteria.GRADE);
        });
        
        EventHandler keyBoardHandler = new EventHandler<KeyEvent>(){
            @Override
            public void handle(KeyEvent event) {
                String eventChar = event.getCharacter();
                switch (eventChar){
                    case "n":
                        OrderBy(OrderCriteria.NAME);
                        break;
                    case "p":
                        OrderBy(OrderCriteria.PRICE);
                        break;
                    case "v":
                        OrderBy(OrderCriteria.GRADE);
                        break;
                }
            }
        };        
        //
        
        //Bottom image building
        imageDisplayer = new ImageDisplayer(locationsArchive);
        imageDisplayer.displayImage(locationsArchive.get(0).name);
        //
        
        //Table building       
        currentDisplay = new ArrayList<>();
        table = new Table(currentDisplay, name, price, grade);
        for(int i=0; i<5; i++){
            currentDisplay.add(new TableRecord(locationsArchive.get(i), imageDisplayer));
        }
        table.refreshTable();
        //
        
        //Final setup
        baseLayout.addEventFilter(KeyEvent.ANY, keyBoardHandler);
        baseLayout.setCenter(table);
        baseLayout.setBottom(imageDisplayer);
        
        Scene scene = new Scene(baseLayout, 500, 520);
        
        primaryStage.setTitle("Matteo Longato");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
    /**
     * Riordina l'archivio di base in base al criterio passato come parametro
     * @param criteria Il criterio da applicare per l'ordinamento
     */
    private void OrderBy(OrderCriteria criteria){
        currentDisplay.clear();
        switch(criteria){
            case NAME:
                locationsArchive.sort((Alloggio a1, Alloggio a2)-> a1.name.compareTo(a2.name));
                break;
            case PRICE:
                locationsArchive.sort((Alloggio a1, Alloggio a2)-> ((Integer)a1.price).compareTo((Integer)a2.price));
                break;
            case GRADE:
                locationsArchive.sort((Alloggio a1, Alloggio a2)-> ((Double)a1.customerGrading).compareTo((Double)a2.customerGrading));
                Collections.reverse(locationsArchive);
                break;
        }
        for(int i=0; i<5; i++){
            currentDisplay.add(new TableRecord(locationsArchive.get(i), imageDisplayer));
        }
        table.refreshTable();
        imageDisplayer.displayImage(locationsArchive.get(0).name);
    }
    
    /**
     * I possibili criteri di ordinamento
     */
    private enum OrderCriteria{
        NAME,
        PRICE,
        GRADE
    }
    
}
