/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.lingProg.longato;

import java.util.List;
import javafx.geometry.HPos;
import javafx.scene.control.Button;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

/**
 * L'effettiva tabella mostrata a schermo con tutte le entry
 * @author matteo.longato
 */
public class Table extends GridPane{
    
    private final List<TableRecord> displayList;
    private final Button nameButton;
    private final Button priceButton;
    private final Button gradeButton;
    
    public Table(List<TableRecord> display, Button name, Button price, Button grade){
        nameButton = name;
        priceButton = price;
        gradeButton = grade;
        this.displayList = display;

        ColumnConstraints column0 = new ColumnConstraints();
        column0.setPercentWidth(30);
        column0.halignmentProperty().setValue(HPos.LEFT);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPercentWidth(20);
        column1.halignmentProperty().setValue(HPos.RIGHT);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPercentWidth(20);
        column2.halignmentProperty().setValue(HPos.RIGHT);
        ColumnConstraints column3 = new ColumnConstraints();
        column3.setPercentWidth(30);
        column3.halignmentProperty().setValue(HPos.CENTER);
        
        this.getColumnConstraints().addAll(column0,column1,column2,column3);
    }
    
    /**
     * Svuota e riempie nuovamente la tabella con la lista di entry aggiornata
     */
    public void refreshTable(){
        if(displayList != null){
            this.getChildren().clear();
            this.add(nameButton, 0, 0);
            this.add(priceButton, 1, 0);
            this.add(gradeButton, 2, 0);
            int i=1;
            for(TableRecord tR:displayList){
                this.add(tR.getName(), 0, i);
                this.add(tR.getPrice(), 1, i);
                this.add(tR.getGrade(), 2, i);
                this.add(tR.getInfo(), 3, i);
                i++;
            }
        }
    }
}
