/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.unitn.disi.lingProg.longato;

import javafx.scene.control.Label;
import javafx.scene.text.Font;
import java.lang.Double;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.FontWeight;

/**
 * Classe rappresentante una entry della tabella di visualizzazione
 * @author matteo.longato
 */
public class TableRecord{
    
    private ImageDisplayer imageDisplayer;
    
    private final Label name;
    private final Label price;
    private final Label grading;
    private final Node extraInfo;
    
    /**
     * Instanzia un record a partire da un Alloggio
     * @param toInsert L'Alloggio rappresentato dal record
     * @param imageDisplayer Il diplayer di immagini della finestra
     */
    public TableRecord(Alloggio toInsert, ImageDisplayer imageDisplayer){
        this.imageDisplayer = imageDisplayer;
        name = new Label(toInsert.name);
        price = new Label(((Integer)toInsert.price).toString());
        grading = new Label(((Double)toInsert.customerGrading).toString());
        extraInfo = toInsert.getAdditionalInfo();
        //extraInfo.getChildren().add(toInsert.getAdditionalInfo());
                
        name.setFont(Font.font("Arial", FontWeight.EXTRA_BOLD, 15));
        price.setFont(Font.font("Arial", FontWeight.EXTRA_BOLD, 15));
        grading.setFont(Font.font("Arial", FontWeight.EXTRA_BOLD, 15));
        
        name.addEventFilter(MouseEvent.MOUSE_CLICKED, (MouseEvent event) -> {
            this.imageDisplayer.displayImage(((Label)event.getSource()).getText());
        });
        
        //this.getChildren().addAll(name, price, grading, extraInfo);
    }
    
    /**
     * Restituisce la Label corrispondente al nome del record
     * @return 
     */
    public Label getName(){
        return this.name;
    }
    
    /**
     * Restituisce la Label corrispondente al prezzo del record
     * @return 
     */
    public Label getPrice(){
        return this.price;
    }
    
    /**
     * Restituisce la Label corrispondente alla valutazione del record
     * @return 
     */
    public Label getGrade(){
        return this.grading;
    }
    
    /**
     * Restituisce la Label corrispondente alle info aggiuntive del record
     * @return 
     */
    public Node getInfo(){
        return this.extraInfo;
    }
}
