/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ronchet.sudoku;

import it.unitn.disi.ronchet.sudoku.Sudoku;
import it.unitn.disi.ronchet.sudoku.cells.FreeCell;
import it.unitn.disi.ronchet.sudoku.cells.UninitializedCell;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class SquareGrid
extends GridPane {
    int order;
    int order2;
    Sudoku s = null;

    public SquareGrid(Sudoku s) {
        int i;
        this.order = s.getOrder();
        this.order2 = this.order * this.order;
        this.s = s;
        this.setGridLinesVisible(true);
        for (i = 0; i < this.order2; ++i) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / (double)this.order2);
            this.getColumnConstraints().add((Object)colConst);
        }
        for (i = 0; i < this.order2; ++i) {
            RowConstraints rowConst = new RowConstraints();
            rowConst.setPercentHeight(100.0 / (double)this.order2);
            this.getRowConstraints().add((Object)rowConst);
        }
    }

    public void generateUnitializedCells() {
        for (int i = 0; i < this.order2; ++i) {
            for (int j = 0; j < this.order2; ++j) {
                UninitializedCell c = new UninitializedCell(i, j, this.s);
                this.add((Node)c, i, j);
            }
        }
    }

    public void generateFreeCells() {
        for (int i = 0; i < this.order2; ++i) {
            for (int j = 0; j < this.order2; ++j) {
                Node x = this.getElementAt(i, j);
                if (!(x instanceof UninitializedCell)) continue;
                this.getChildren().remove((Object)x);
                FreeCell f = new FreeCell(i, j, this.s);
                this.add((Node)f, i, j);
            }
        }
        this.s.setCount(this.order2 * (this.order2 - 1));
    }

    Node getElementAt(int i, int j) {
        for (Node x : this.getChildren()) {
            if (GridPane.getColumnIndex((Node)x) == null || GridPane.getColumnIndex((Node)x) != i || GridPane.getRowIndex((Node)x) == null || GridPane.getRowIndex((Node)x) != j) continue;
            return x;
        }
        return null;
    }
}

