/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ronchet.sudoku;

import it.unitn.disi.ronchet.sudoku.DialogGenerator;
import it.unitn.disi.ronchet.sudoku.SquareGrid;
import it.unitn.disi.ronchet.sudoku.Validator;
import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Sudoku
extends Application {
    public static final int WIDTH = 500;
    public static final int[] CELLWIDTH = new int[]{100, 50};
    private int count = 0;
    private int order = 0;
    public int numberOfFixedCellsToBeCreated = 0;
    private Text counterText = null;
    private SquareGrid grid = null;
    private BorderPane bp = null;
    private ChoiceBox cb = null;
    public Validator validator = null;
    public final Color[] colors = new Color[]{Color.LIGHTYELLOW, Color.LIGHTPINK, Color.LIGHTSTEELBLUE, Color.LIGHTGREEN, Color.LIGHTBLUE, Color.LIGHTSALMON, Color.LAVENDER, Color.BISQUE, Color.HONEYDEW};

    public SquareGrid getGrid() {
        return this.grid;
    }

    public int getChoiceBoxValue() {
        String v = (String)this.cb.getValue();
        return Integer.parseInt(v);
    }

    public void setCount(int c) {
        this.count = c;
        this.counterText.setText("" + this.count);
    }

    public int getCount() {
        return this.count;
    }

    public int getOrder() {
        return this.order;
    }

    public void start(Stage primaryStage) {
        int order2;
        do {
            this.order = DialogGenerator.createNumericDialog("Richiesta di input", "Inserisci il valore", "Ordine", "3", "Errore - deve essere un numero!");
        } while (this.order < 2 || this.order > 3);
        this.numberOfFixedCellsToBeCreated = order2 = this.order * this.order;
        this.validator = new Validator(this.order);
        HBox hb = new HBox();
        hb.setAlignment(Pos.CENTER);
        hb.setSpacing(20.0);
        this.cb = new ChoiceBox();
        for (int i = 1; i <= order2; ++i) {
            this.cb.getItems().add((Object)("" + i));
        }
        this.cb.setValue((Object)"1");
        Label label = new Label("valore");
        hb.getChildren().add((Object)label);
        hb.getChildren().add((Object)this.cb);
        Label label2 = new Label("Celle libere");
        this.counterText = new Text("" + this.count);
        hb.getChildren().add((Object)label2);
        hb.getChildren().add((Object)this.counterText);
        this.bp = new BorderPane();
        this.bp.setBottom((Node)hb);
        this.grid = new SquareGrid(this);
        this.bp.setCenter((Node)this.grid);
        this.grid.generateUnitializedCells();
        Scene scene = new Scene((Parent)this.bp, 500.0, 525.0);
        primaryStage.setTitle("Nome Cognome");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public static void main(String[] args) {
        Sudoku.launch((String[])args);
    }

    public void declareVictory() {
        DialogGenerator.createAlert("Vittoria", "Hai vinto!", "Complimenti.");
    }
}

