/*
 * Decompiled with CFR 0.152.
 */
package it.unitn.disi.ronchet.sudoku;

import java.util.HashSet;
import java.util.Set;

public class Validator {
    Set<Integer>[] rowSet;
    Set<Integer>[] columnSet;
    Set<Integer>[] regionSet;
    int order = 0;

    public Validator(int order) {
        this.order = order;
        int n = order * order;
        this.rowSet = new HashSet[n];
        this.columnSet = new HashSet[n];
        this.regionSet = new HashSet[n];
        for (int i = 0; i < n; ++i) {
            this.rowSet[i] = new HashSet<Integer>();
            this.columnSet[i] = new HashSet<Integer>();
            this.regionSet[i] = new HashSet<Integer>();
        }
    }

    boolean checkIfValueIsOk(int value, int col, int row) {
        if (this.rowSet[row].contains(value)) {
            System.out.println(value + "ERROR - ROW " + row);
            return false;
        }
        if (this.columnSet[col].contains(value)) {
            System.out.println(value + "ERROR - COLUMN " + col);
            return false;
        }
        int region = this.findRegion(col, row);
        if (this.regionSet[region].contains(value)) {
            System.out.println(value + "ERROR - REGION: " + region + "-" + col + " " + row);
            return false;
        }
        return true;
    }

    public boolean add(int value, int col, int row) {
        if (!this.checkIfValueIsOk(value, col, row)) {
            return false;
        }
        this.rowSet[row].add(value);
        this.columnSet[col].add(value);
        int region = this.findRegion(col, row);
        this.regionSet[region].add(value);
        return true;
    }

    public boolean remove(int value, int col, int row) {
        if (this.checkIfValueIsOk(value, col, row)) {
            return false;
        }
        this.rowSet[row].remove(value);
        this.columnSet[col].remove(value);
        int region = this.findRegion(col, row);
        this.regionSet[region].remove(value);
        return true;
    }

    public int findRegion(int i, int j) {
        int region = 0;
        int x = i / this.order;
        int y = j / this.order;
        switch (x) {
            case 0: {
                region = y;
                break;
            }
            case 1: {
                region = this.order + y;
                break;
            }
            case 2: {
                region = 2 * this.order + y;
            }
        }
        return region;
    }
}

