package it.unitn.disi.ronchet.sudoku;

import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.TextInputDialog;
/**
 * classe di utilità per generare dialoghi di vario tipo.
 * L'uso di static qui è ammessibile perchè definiamo metodi di classe
 * e non creiamo qualcosa che somigli a variabili globali.
 * @author ronchet
 */
public class DialogGenerator {

    public static void createAlert(String title, String header, String content) {
        Alert alert = new Alert(AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.showAndWait();
    }

    public static String createDialog(String title, String textinput, String answerLabel, String defaultAnswer) {
        TextInputDialog dialog = new TextInputDialog(defaultAnswer);
        dialog.setTitle(title);
        dialog.setHeaderText(textinput);
        dialog.setContentText(answerLabel);
        return dialog.showAndWait().get();
    }

    public static int createNumericDialog(String title, String textinput, String answerLabel, String defaultAnswer, String errorMessage) {
        boolean isOK = false;
        int response = 0;
        String msg = "Inserisci il valore";
        while (!isOK) {
            String s = DialogGenerator.createDialog(title, textinput, answerLabel, defaultAnswer);
            try {
                response = Integer.parseInt(s);
                isOK = true;
            } catch (NumberFormatException ex) {
                msg = errorMessage;
                isOK = false;
            }
        }
        return response;
    }
}
