package it.unitn.disi.ronchet.sudoku;

import it.unitn.disi.ronchet.sudoku.cells.Cell;
import it.unitn.disi.ronchet.sudoku.cells.FreeCell;
import it.unitn.disi.ronchet.sudoku.cells.UninitializedCell;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class SquareGrid extends GridPane {

    int order;
    int order2;
    Sudoku s=null;

    public SquareGrid(Sudoku s) {
        order = s.getOrder();
        order2 = order * order;
        this.s=s;
        setGridLinesVisible(true);
        for (int i = 0; i < order2; i++) {
            ColumnConstraints colConst = new ColumnConstraints();
            colConst.setPercentWidth(100.0 / order2);
            this.getColumnConstraints().add(colConst);
        }
        for (int i = 0; i < order2; i++) {
            RowConstraints rowConst = new RowConstraints();
            rowConst.setPercentHeight(100.0 / order2);
            this.getRowConstraints().add(rowConst);
        }
    }
    /**
     * genera celle non inizializzate per tutta la griglia
     */
    public void generateUnitializedCells() {
        for (int i = 0; i < order2; i++) {
            for (int j = 0; j < order2; j++) {
                Cell c = new UninitializedCell(i, j, s);
                add(c, i, j);
            }
        }
    }
    /**
     * Sostituisce tutte le UninitializedCell con FreeCell
     */
    public void generateFreeCells() {
        for (int i = 0; i < order2; i++) {
            for (int j = 0; j < order2; j++) {
                Node x=getElementAt(i, j);
                if (x instanceof UninitializedCell) {
                    this.getChildren().remove(x);
                    Cell f = new FreeCell(i, j, s);
                    this.add(f, i, j);
                }
            }
        }
        s.setCount(order2*(order2-1));
    }
    /**
     * Restituisce l'elemento che si trova in posizione i,j nella griglia
     * @param i
     * @param j
     * @return 
     */
    Node getElementAt(int i, int j) {
        for (Node x : getChildren()) {
            if ((GridPane.getColumnIndex(x) != null && GridPane.getColumnIndex(x) == i)
                    && (GridPane.getRowIndex(x) != null && GridPane.getRowIndex(x) == j)) {
                return x;
            }
        }
        return null;
    }

}
