    package it.unitn.disi.ronchet.sudoku;

import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Sudoku extends Application {

    public static final int WIDTH=500;
    public static final int CELLWIDTH[]={100,50};
    private int count = 0;
    private int order=0;
    public int numberOfFixedCellsToBeCreated=0;
    private Text counterText = null;
    private SquareGrid grid = null;
    private BorderPane bp = null;
    private ChoiceBox cb = null;
    public Validator validator=null;
    public final Color colors[] = {
        Color.LIGHTYELLOW,
        Color.LIGHTPINK,
        Color.LIGHTSTEELBLUE,
        Color.LIGHTGREEN,
        Color.LIGHTBLUE,
        Color.LIGHTSALMON,
        Color.LAVENDER,
        Color.BISQUE,
        Color.HONEYDEW
    };
    public SquareGrid getGrid() {return grid;}
    public int getChoiceBoxValue() {
        String v=(String)cb.getValue();
        return Integer.parseInt(v);
    }
    public void setCount(int c) {
        count=c;
        counterText.setText(""+count);
    }
    public int getCount() {return count;}
    public int getOrder() {return order;}
    
    @Override
    public void start(Stage primaryStage) {
        do {
            order=DialogGenerator.createNumericDialog("Richiesta di input", "Inserisci il valore", "Ordine", "3","Errore - deve essere un numero!");
        } while (order<2||order>3);
        int order2=order*order;
        numberOfFixedCellsToBeCreated=order2;
        validator=new Validator(order);
        // -- set up della grafica
        // definisci la fascia inferiore
        HBox hb = new HBox();
        hb.setAlignment(Pos.CENTER);
        hb.setSpacing(20);        
        // definisci e aggiungi il checkBox
        cb = new ChoiceBox();
        for (int i=1; i<=order2; i++) { 
            cb.getItems().add(""+i);
        }
        cb.setValue("1");
        Label label=new Label("valore");
        hb.getChildren().add(label);
        hb.getChildren().add(cb);
        // aggiungi il contatore
        Label label2=new Label("Celle libere");
        counterText = new Text("" + count);
        hb.getChildren().add(label2);
        hb.getChildren().add(counterText);
        // definisci il contentore principale
        // aggiungi la fascia inferiore e la griglia
        bp = new BorderPane();
        bp.setBottom(hb);
        grid = new SquareGrid(this);
        bp.setCenter(grid);
        grid.generateUnitializedCells();
        // crea la scena e mostrala
        Scene scene = new Scene(bp, WIDTH, 525);
        primaryStage.setTitle("Nome Cognome");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }

    public void declareVictory() {
        DialogGenerator.createAlert("Vittoria", "Hai vinto!", "Complimenti.");
    }
}
       
