package it.unitn.disi.ronchet.sudoku;

import java.util.HashSet;
import java.util.Set;
/**
 * Validator: 
 * @author ronchet
 */
public class Validator {
    // definiamo un Set per ogni riga, per ogni colonna
    // e per ogni regione. In ciascuno di essi non vi possono
    // essere elementi duplicati
    Set<Integer> rowSet[];
    Set<Integer> columnSet[];
    Set<Integer> regionSet[];
    int order=0;
    public Validator(int order) {
        this.order=order;
        int n=order*order;
        this.rowSet = new HashSet[n];
        this.columnSet = new HashSet[n];
        this.regionSet = new HashSet[n];
        for (int i=0; i<n; i++) {
            rowSet[i]=new HashSet<Integer>();
            columnSet[i]=new HashSet<Integer>();
            regionSet[i]=new HashSet<Integer>();
        }
    }
    /**
     * dati un valore, e le coordinate di una cella verifica se il
     * valore è ammissibile per la cella stessa
     * @param value
     * @param col
     * @param row
     * @return 
     */
    boolean checkIfValueIsOk(int value, int col, int row) {
        if (rowSet[row].contains(value)) {
            System.out.println(value+" ROW "+row);
            return false;
        }
        if (columnSet[col].contains(value)) {
            System.out.println(value+" COLUMN "+col);
            return false;
        }
        int region=findRegion(col,row);
        if (regionSet[region].contains(value)) {
            System.out.println(value+" REGION: "+region+"-"+col+" "+row);
            return false;
        }
        return true;
    }
    /**
     * setta il valore di una cella se questo è ammissibile
     * @param value
     * @param col
     * @param row
     * @return 
     */
    public boolean add(int value, int col, int row) {
        if (!checkIfValueIsOk(value,col,row)) return false; // element is already contained
        rowSet[row].add(value);
        columnSet[col].add(value);
        int region=findRegion(col,row);
        regionSet[region].add(value);
        return true;
    }
    /**
     * Rimuove il valore da una cella e aggiorna i relativi set
     * usati per verificare i permessi
     * @param value
     * @param col
     * @param row
     * @return 
     */
    public boolean remove(int value, int col, int row) {
        if (checkIfValueIsOk(value,col,row)) return false; // element is not contained
        rowSet[row].remove(value);
        columnSet[col].remove(value);
        int region=findRegion(col,row);
        regionSet[region].remove(value);
        return true;
    }
    /**
     * date le coordinate di una cella ne restituisce 
     * la regione di appartenenza
     * @param i
     * @param j
     * @return 
     */
    public int findRegion(int i, int j) {
        int region=0;
        int x = i / order; 
        int y = j / order;
        switch (x) {
            case 0:
                region = y;
                break;
            case 1:
                region = order + y;
                break;
            case 2:
                region = 2 * order + y;
        }
        return region;
    }
}
