package it.unitn.disi.ronchet.sudoku.cells;

import it.unitn.disi.ronchet.sudoku.NumberText;
import it.unitn.disi.ronchet.sudoku.SquareGrid;
import it.unitn.disi.ronchet.sudoku.Sudoku;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public abstract class Cell extends StackPane {
    int i, j;
    int value=0;
    SquareGrid grid;
    Shape background;
    NumberText nt=new NumberText();

    public Cell(int i, int j, Sudoku s) {
        this.i = i;
        this.j = j;
        this.grid = s.getGrid();
        int order=s.getOrder();
        int cellDimension=Sudoku.CELLWIDTH[order-2];
        background= new Rectangle(cellDimension, cellDimension);
        this.getChildren().add(background);
        this.getChildren().add(nt);
    }
}
